
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data representing "Media Analytics"
# x-axis: Time in weeks
# y-axis: Various engagement metrics

# Data for clicks
x1 = np.array([1, 2, 3, 4, 5])
y1 = np.array([120, 135, 150, 160, 170])
e1 = np.array([10, 5, 15, 10, 10])

# Data for shares
x2 = np.array([1, 2, 3, 4])
y2 = np.array([50, 60, 58, 65])
e2 = np.array([5, 3, 4, 5])

# Data for views
x3 = np.array([1, 2, 3, 4, 5, 6])
y3 = np.array([300, 320, 305, 310, 325, 330])
e3 = np.array([15, 20, 10, 12, 18, 15])

# Data for likes
x4 = np.array([1, 2, 3, 4, 5])
y4 = np.array([80, 90, 85, 88, 92])
e4 = np.array([8, 5, 10, 7, 6])

# Titles
titles = [
    "(a) Weekly Clicks",
    "(b) Weekly Shares",
    "(c) Weekly Views",
    "(d) Weekly Likes",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [(x1, y1, e1), (x2, y2, e2), (x3, y3, e3), (x4, y4, e4)]

# Custom colors and styles
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
markers = ["o", "s", "D", "^"]

# Plot with error bars in each subplot
for ax, (x, y, e), title, color, marker in zip(axs, data, titles, colors, markers):
    ax.errorbar(
        x, y, yerr=e, fmt=f"-{marker}", color=color, ecolor="gray", 
        elinewidth=1, capsize=5, markersize=7, linestyle='-', linewidth=2
    )
    ax.set_title(title, fontsize=16)
    ax.set_xlabel('Weeks', fontsize=12)
    ax.set_ylabel('Engagement', fontsize=12)
    ax.grid(True, which='both', linestyle='--', linewidth=0.5, alpha=0.7)
    ax.set_xticks(np.arange(min(x), max(x) + 1, 1))
    ax.set_yticks(np.linspace(min(y) - min(e), max(y) + max(e), num=5, endpoint=True))

# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_226.pdf", bbox_inches="tight")
