
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Titles and generated data for philosophical trends
titles = [
    "Socrates Influence",
    "Plato Influence",
    "Aristotle Influence",
    "Stoicism Popularity",
    "Existentialism Growth",
    "Postmodernism Trends"
]

# Example X values could represent years or periods
years = [
    np.array([450, 400, 350, 300, 250]),
    np.array([400, 350, 300, 250]),
    np.array([380, 340, 300, 260, 220, 180]),
    np.array([100, 200, 300, 400, 500]),
    np.array([1850, 1900, 1950, 2000, 2050]),
    np.array([1950, 1975, 2000, 2025, 2050])
]

# Y values could represent influence score, popularity or growth percentage
influence = [
    np.random.uniform(70, 90, size=len(years[0])),
    np.random.uniform(65, 85, size=len(years[1])),
    np.random.uniform(60, 80, size=len(years[2])),
    np.random.uniform(55, 75, size=len(years[3])),
    np.random.uniform(50, 70, size=len(years[4])),
    np.random.uniform(45, 65, size=len(years[5]))
]

# Error margins for historical uncertainty
errors = [
    np.random.uniform(1, 4, size=len(years[0])),
    np.random.uniform(1, 4, size=len(years[1])),
    np.random.uniform(1, 6, size=len(years[2])),
    np.random.uniform(1, 4, size=len(years[3])),
    np.random.uniform(1, 4, size=len(years[4])),
    np.random.uniform(1, 4, size=len(years[5]))
]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(2, 3, figsize=(12, 8))
# Color scheme inspired by classical art
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

# Line styles and markers
line_styles = ['-', '--', '-.', ':', '-', '--']
markers = ['o', 's', 'D', '^', '*', 'x']

data_pairs = list(zip(years, influence, errors))

for ax, (x, y, e), title, color, line_style, marker in zip(axs.flat, data_pairs, titles, colors, line_styles, markers):
    ax.errorbar(
        x, y, yerr=e, fmt=line_style+marker, color=color, ecolor="lightgray", capsize=5, label=title
    )
    ax.set_title(title)
    ax.set_xlabel("Year")
    ax.set_ylabel("Influence/Popularity")
    ax.set_xticks(x)
    ax.set_ylim(min(y) - min(e) - 1, max(y) + max(e) + 1)
    ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_227.pdf", bbox_inches="tight")
