
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
adoption_strategies = ["Early Adoption", "Late Adoption", "Sustained Use", "Declining Use"]
engagement_mobile = [0.9, 0.8, 0.7, 0.4]
engagement_web = [0.85, 0.75, 0.65, 0.3]
engagement_iot = [0.75, 0.7, 0.6, 0.4]
engagement_ai = [0.95, 0.85, 0.7, 0.5]
error = [0.05, 0.06, 0.07, 0.05]

# Axes Limits and Labels
xlabel_value = "Adoption Strategy"
ylabel_value = "Engagement Level"
ylim_values = [0, 1]

# Titles
titles = ["Mobile vs Web", "IoT vs AI", "Web vs IoT"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Titles and setup for subplots
data_pairs = [
    (engagement_mobile, engagement_web),
    (engagement_iot, engagement_ai),
    (engagement_web, engagement_iot),
]
colors_pairs = [("#1f77b4", "#ff7f0e"), ("#2ca02c", "#d62728"), ("#ff7f0e", "#2ca02c")]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2) in zip(axs, titles, data_pairs, colors_pairs):
    ax.errorbar(
        adoption_strategies,
        data1,
        yerr=error,
        fmt="o-",
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        markersize=8,
        label=f'{title.split(" vs ")[0]}',
    )
    ax.errorbar(
        adoption_strategies,
        data2,
        yerr=error,
        fmt="s-",
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        markersize=8,
        label=f'{title.split(" vs ")[1]}',
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(axis="both", which="major", length=5, direction="in", top=True, right=True)
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.7)
    ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_230.pdf", bbox_inches="tight")

