
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
energy_sources = ["Coal", "Natural Gas", "Nuclear", "Renewables"]
consumption_past = [2.0, 1.5, 1.0, 0.5]
consumption_present = [1.5, 2.0, 1.2, 1.5]
consumption_future = [1.0, 2.2, 1.5, 2.5]  # Additional data for future prediction
consumption_projection = [1.2, 2.1, 1.4, 2.0]  # Additional projection data
error = [0.1, 0.1, 0.1, 0.1]

# Axes Limits and Labels
xlabel_value = "Energy Source"
ylabel_value = "Consumption (TWh)"
ylim_values = [0, 3]

# Titles
titles = ["Past vs Present", "Future vs Projection", "Present vs Future"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(12, 4))

# Titles and setup for subplots
data_pairs = [
    (consumption_past, consumption_present),
    (consumption_future, consumption_projection),
    (consumption_present, consumption_future),
]
colors_pairs = [("#66545E", "#556270"), ("#355C7D", "#C06C84"), ("#556270", "#355C7D")]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2) in zip(
    axs, titles, data_pairs, colors_pairs
):
    ax.errorbar(
        energy_sources,
        data1,
        yerr=error,
        fmt="o-",
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[0]}',
    )
    ax.errorbar(
        energy_sources,
        data2,
        yerr=error,
        fmt="s-",
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[1]}',
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(
        axis="both", which="major", length=5, direction="in", top=True, right=True
    )
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.5)
    ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_232.pdf", bbox_inches="tight")
