
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Updated domain-specific data
n_aug = ["0", "0.125", "0.25", "0.5", "1", "2", "4", "8"]
creativity = np.array([3, 5, 8, 7, 6, 5.5, 5, 4])  # Mid peak with slight decrease
quality = np.array([2, 3, 4, 5, 6, 6.5, 6, 5.5])  # Smooth increase then plateau
engagement = np.array([1, 3, 5, 7, 8, 6, 4, 2])  # High peak in the middle

# Axes Limits and Labels
xlabel_value = "n$_{aug}$"
xlim_values = [0, len(n_aug) - 1]

ylabel_value = "Performance Metrics (%)"
ylim_values = [0, max(creativity) + 1]

# Labels
label_Creativity = "Creativity"
label_Quality = "Quality"
label_Engagement = "Engagement"

# Titles
title = "Performance Metrics Across Different n$_{aug}$ Levels"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 3))
ax.plot(
    n_aug,
    creativity,
    "D-",
    label=label_Creativity,
    color="#ff6347",  # Tomato color
    linewidth=2,
    markersize=8,
)
ax.plot(
    n_aug,
    quality,
    "P--",
    label=label_Quality,
    color="#4682b4",  # Steel Blue color
    linewidth=2,
    markersize=8,
)
ax.plot(
    n_aug,
    engagement,
    "o:",
    label=label_Engagement,
    color="#32cd32",  # Lime Green color
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f0f8ff")  # Alice Blue background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper left", fontsize=10, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_235.pdf", bbox_inches="tight")
