
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data setup
quarters = np.array([1, 2, 3, 4, 5])
stock_a_prices = np.array([150, 160, 165, 170, 175])
stock_b_prices = np.array([100, 105, 107, 108, 110])
revenue_growth = np.array([10, 12, 15, 18, 20])
profit_margins = np.array([5, 6, 7, 8, 9])

# Axes Limits and Labels
xlabel_value = "Quarter"
xlim_values = [0, 6]
ylabel_value = "Value"
ylim_values = [90, 180]

# Labels
label_1 = "Stock A Prices"
label_2 = "Stock B Prices"
label_3 = "Revenue Growth (%)"
label_4 = "Profit Margins (%)"

# Titles
title_1 = "Stock Prices Over Quarters"
title_2 = "Stock Prices Comparison"
title_3 = "Revenue Growth & Profit Margins"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#1abc9c", "#2c3e50", "#16a085", "#95a5a6"]

# Create the 1x3 subplot configuration
fig, axs = plt.subplots(1, 3, figsize=(12, 4))

# Plot customization for a fancy look
marker_styles = ["o", "^", "s", "x"]
line_styles = ["-", "--", "-.", ":"]

# First subplot for Stock A Prices
axs[0].plot(
    quarters,
    stock_a_prices,
    label=label_1,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)

# Second subplot for Stock B Prices
axs[1].plot(
    quarters,
    stock_b_prices,
    label=label_2,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)

# Third subplot for Revenue Growth & Profit Margins
axs[2].plot(
    quarters,
    revenue_growth,
    label=label_3,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[2].plot(
    quarters,
    profit_margins,
    label=label_4,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_xlabel(xlabel_value, fontsize=12)
axs[2].set_ylabel(ylabel_value, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(quarters)
    ax.set_xlim(xlim_values)
    ax.set_ylim(ylim_values)
    ax.legend(loc="upper left", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()

# Show the plot
plt.savefig("line_236.pdf", bbox_inches="tight")
