
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Library for numerical operations
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Week data
weeks = np.array([0, 2, 4, 6, 8, 10])

# Average ratings
ratings_action = np.array([7.5, 7.4, 7.3, 7.2, 7.1, 7.0])
ratings_comedy = np.array([6.5, 6.6, 6.7, 6.8, 6.9, 7.0])
ratings_drama = np.array([8.0, 8.1, 8.2, 8.3, 8.4, 8.5])
ratings_scifi = np.array([7.0, 7.1, 7.2, 7.3, 7.4, 7.5])

# Cumulative box office revenue (in millions)
box_office_action = np.array([50, 150, 300, 400, 450, 480])
box_office_comedy = np.array([30, 80, 150, 200, 230, 250])
box_office_drama = np.array([20, 70, 140, 180, 220, 250])
box_office_scifi = np.array([40, 120, 220, 300, 360, 400])

# Axes Limits and Labels
xlabel_value = "Weeks After Release"
xlim_values = [-1, 11]
ylabel_ratings = "Average Rating"
ylabel_box_office = "Cumulative Box Office (Millions)"
ylim_ratings = [6.0, 9.0]
ylim_box_office = [0, 500]

# Labels for legends
label_action = "Action"
label_comedy = "Comedy"
label_drama = "Drama"
label_scifi = "Sci-Fi"

# Titles for subplots
title_ratings = "Average Ratings Over Time"
title_box_office = "Cumulative Box Office Revenue"

# Super title for the overall plots
supertitle = "Movie Performance Over Time by Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#FF5733", "#33FF57", "#3357FF", "#FF33A6"]

# Create the 1x2 subplot configuration
fig, axs = plt.subplots(1, 2, figsize=(12, 5))

# Plot customization for a fancy look
marker_styles = ["o", "^", "s", "x"]
line_styles = ["-", "--", ":", "-."]

# First subplot for average ratings
axs[0].plot(
    weeks,
    ratings_action,
    label=label_action,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    weeks,
    ratings_comedy,
    label=label_comedy,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    weeks,
    ratings_drama,
    label=label_drama,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    weeks,
    ratings_scifi,
    label=label_scifi,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_ratings, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_ratings, fontsize=12)

# Second subplot for box office revenue
axs[1].plot(
    weeks,
    box_office_action,
    label=label_action,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    weeks,
    box_office_comedy,
    label=label_comedy,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    weeks,
    box_office_drama,
    label=label_drama,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    weeks,
    box_office_scifi,
    label=label_scifi,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_box_office, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_box_office, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(weeks)
    ax.set_xlim(xlim_values)
    ax.legend(loc="upper left", fontsize=10)

# Set super title
plt.suptitle(supertitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Show the plot
plt.savefig("line_237.pdf", bbox_inches="tight")
