
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data setup for soccer team performance metrics
matches_played = np.array([1, 2, 3, 4, 5])
team_A_performance = np.array([0.75, 0.78, 0.80, 0.82, 0.85])
team_B_performance = np.array([0.70, 0.73, 0.75, 0.77, 0.80])
team_C_performance = np.array([0.65, 0.68, 0.70, 0.72, 0.75])
team_D_performance = np.array([0.60, 0.63, 0.65, 0.68, 0.70])

# Axes Limits and Labels
xlabel_value = "Matches Played"
xlim_values = [0, 6]
ylabel_value = "Performance Score"
ylim_values = [0.55, 0.90]

# Labels for the chart
label_A = "Team A"
label_B = "Team B"
label_C = "Team C"
label_D = "Team D"

# Titles
title_1 = "Team A Performance"
title_2 = "Team B Performance"
title_3 = "Team C & Team D Performance"

# Legend Labels
legend_labels = ["Team A", "Team B", "Team C", "Team D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Create the 1x3 subplot configuration
fig, axs = plt.subplots(1, 3, figsize=(9, 3))

# Plot customization for a polished look
marker_styles = ["o", "s", "D", "^"]
line_styles = ["-", "--", "-.", ":"]

# First subplot for Team A
axs[0].plot(
    matches_played,
    team_A_performance,
    label=label_A,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)

# Second subplot for Team B
axs[1].plot(
    matches_played,
    team_B_performance,
    label=label_B,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)

# Third subplot for Team C & Team D
axs[2].plot(
    matches_played,
    team_C_performance,
    label=label_C,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[2].plot(
    matches_played,
    team_D_performance,
    label=label_D,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_xlabel(xlabel_value, fontsize=12)
axs[2].set_ylabel(ylabel_value, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(matches_played)
    ax.set_xlim(xlim_values)
    ax.set_ylim(ylim_values)
    ax.legend(loc="lower right", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()

# Show the plot
plt.savefig("line_238.pdf", bbox_inches="tight")

