
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Simulated sports training data
training_duration = [1, 2, 3, 4]  # Training session duration in hours
avg_speed_moderate = np.array([10, 12, 15, 18])  # Average speed in km/h for moderate training
avg_speed_intense = np.array([12, 15, 18, 22])  # Average speed in km/h for intense training
endurance_moderate = np.array([30, 45, 60, 75])  # Endurance in minutes for moderate training
endurance_intense = np.array([35, 50, 70, 90])  # Endurance in minutes for intense training

# Axes Limits and Labels
xlabel_value = "Training Session Duration (hours)"
ylabel_value_speed = "Average Speed (km/h)"
ylabel_value_endurance = "Endurance (minutes)"

# Labels
label_speed = "Average Speed"
label_endurance = "Endurance"
label_moderate = " (Moderate Training)"
label_intense = " (Intense Training)"
title_speed_vs_duration = "Speed vs. Training Duration"
title_endurance_vs_duration = "Endurance vs. Training Duration"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the sports theme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, ylabel, marker1, marker2, color1, color2, label1, label2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        linestyle='--',
        color=color1,
        label=label1,
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        linestyle='-',
        color=color2,
        label=label2,
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    training_duration,
    avg_speed_moderate,
    avg_speed_intense,
    title_speed_vs_duration,
    ylabel_value_speed,
    "o",
    "s",
    colors[0],
    colors[1],
    f"{label_speed}{label_moderate}",
    f"{label_speed}{label_intense}",
)
plot_data(
    axs[0, 1],
    training_duration,
    endurance_moderate,
    endurance_intense,
    title_endurance_vs_duration,
    ylabel_value_endurance,
    "^",
    "d",
    colors[2],
    colors[3],
    f"{label_endurance}{label_moderate}",
    f"{label_endurance}{label_intense}",
)
plot_data(
    axs[1, 0],
    training_duration,
    avg_speed_intense,
    avg_speed_moderate,
    title_speed_vs_duration,
    ylabel_value_speed,
    "p",
    "*",
    colors[1],
    colors[0],
    f"{label_speed}{label_intense}",
    f"{label_speed}{label_moderate}",
)
plot_data(
    axs[1, 1],
    training_duration,
    endurance_intense,
    endurance_moderate,
    title_endurance_vs_duration,
    ylabel_value_endurance,
    "H",
    "X",
    colors[3],
    colors[2],
    f"{label_endurance}{label_intense}",
    f"{label_endurance}{label_moderate}",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_241.pdf", bbox_inches="tight")
