
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for the plot
months = np.linspace(1, 12, 12)
service1_subscribers = np.cumsum(np.random.normal(10000, 2000, 12))
service2_subscribers = np.cumsum(np.random.normal(8000, 2500, 12))

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Number of Subscribers (in thousands)"
ylim_values = [0, max(service1_subscribers.max(), service2_subscribers.max()) + 5000]

# Labels
label_Service1_Model = "Streaming Service A"
label_Service2_Model = "Streaming Service B"

# Titles
title = "Subscriber Growth Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
color_service1 = "forestgreen"
color_service2 = "royalblue"
marker_service1 = "s"
marker_service2 = "^"
style_service1 = "--"
style_service2 = "-."

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(
    months,
    service1_subscribers,
    label=label_Service1_Model,
    color=color_service1,
    marker=marker_service1,
    markersize=5,
    linestyle=style_service1,
    linewidth=2,
)
ax.plot(
    months,
    service2_subscribers,
    label=label_Service2_Model,
    color=color_service2,
    marker=marker_service2,
    markersize=5,
    linestyle=style_service2,
    linewidth=2,
    alpha=0.8,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add a legend to the plot
ax.set_ylim(ylim_values)
ax.legend(loc="upper left", frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_246.pdf", bbox_inches="tight")
