
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
weeks = np.arange(1, 29)

# Simulating meteorological data
temperature_data = 15 + 10 * np.sin(2 * np.pi * weeks / len(weeks)) + np.random.normal(0, 2, len(weeks))
humidity_data = 60 + 20 * np.cos(2 * np.pi * weeks / len(weeks)) + np.random.normal(0, 5, len(weeks))

# Axes Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Temperature (°C)"
ylabel_value_2 = "Humidity (%)"
ylim_temperature = [0, 30]
ylim_humidity = [30, 100]

# Labels
label_temperature = "Temperature"
label_humidity = "Humidity"

# Titles
title = "Temperature and Humidity Trends Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the temperature data on the primary y-axis
color_temperature = "#FF5733"  # Orange
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color_temperature)
ax1.plot(weeks, temperature_data, label=label_temperature, color=color_temperature, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color_temperature)
ax1.set_ylim(ylim_temperature)

# Create a secondary y-axis and plot the humidity data
ax2 = ax1.twinx()
color_humidity = "#33A2FF"  # Teal
ax2.set_ylabel(ylabel_value_2, color=color_humidity)
ax2.plot(weeks, humidity_data, label=label_humidity, color=color_humidity, marker="x", linestyle="--", linewidth=2)
ax2.tick_params(axis="y", labelcolor=color_humidity)
ax2.set_ylim(ylim_humidity)

# Add legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()  
plt.savefig("line_250.pdf", bbox_inches="tight")
