
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

weeks = np.arange(1, 29)

# Generate simulated environmental data
temperature = 10 + 15 * np.sin(2 * np.pi * weeks / 52) + np.random.normal(0, 2, len(weeks))
precipitation = 50 + 20 * np.cos(3 * np.pi * weeks / 52) + np.random.normal(0, 5, len(weeks))

# Calculate the upper and lower bounds for the confidence interval
temperature_upper = temperature + 2
temperature_lower = temperature - 2
precipitation_upper = precipitation + 5
precipitation_lower = precipitation - 5

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Values"

# Labels
labelTemperature = "Temperature (°C)"
label_Precipitation = "Precipitation (mm)"

# Titles
title = "Weekly Temperature and Precipitation"
title_2 = "Environmental Trends Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the temperature data line and fill the confidence interval
ax.plot(
    weeks, 
    temperature, 
    label=labelTemperature, 
    color="royalblue", 
    marker="^", 
    linestyle="-", 
    linewidth=2
)
ax.fill_between(
    weeks, temperature_lower, temperature_upper, color="royalblue", alpha=0.1
)

# Plot the precipitation data line and fill the confidence interval
ax.plot(
    weeks,
    precipitation,
    label=label_Precipitation,
    color="forestgreen",
    marker="s",
    linestyle="--",
    linewidth=2
)
ax.fill_between(
    weeks, precipitation_lower, precipitation_upper, color="forestgreen", alpha=0.1
)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title, fontsize=16)
ax.legend()

# Add grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_252.pdf", bbox_inches="tight")
