
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic business data
weeks = np.arange(1, 29)
sales_performance = np.linspace(50, 150, len(weeks)) + np.random.normal(0, 5, len(weeks))
budget_efficiency = np.linspace(80, 120, len(weeks)) + np.random.normal(0, 5, len(weeks))

# Calculate the upper and lower bounds for the data (confidence intervals)
sales_upper = sales_performance + 7
sales_lower = sales_performance - 7
budget_upper = budget_efficiency + 5
budget_lower = budget_efficiency - 5

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Values"

# Labels
labelSales = "Sales Performance"
labelBudget = "Budget Efficiency"

# Titles
title = "Sales Performance and Budget Efficiency Analysis"
legendTitle = "Legend"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the sales performance data line and fill the confidence interval
ax.plot(
    weeks,
    sales_performance,
    label=labelSales,
    color="forestgreen",
    marker="o",
    linestyle="-",
    linewidth=2,
)
ax.fill_between(
    weeks, sales_lower, sales_upper, color="forestgreen", alpha=0.3
)

# Plot the budget efficiency data line and fill the confidence interval
ax.plot(
    weeks,
    budget_efficiency,
    label=labelBudget,
    color="darkorange",
    marker="d",
    linestyle="--",
    linewidth=2,
)
ax.fill_between(weeks, budget_lower, budget_upper, color="darkorange", alpha=0.3)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title, fontsize=16)
ax.legend(loc="best", title=legendTitle)

# Add a grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_253.pdf", bbox_inches="tight")
