
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
weeks = np.arange(1, 29)
happiness = np.clip(0.6 + 0.3 * np.sin(weeks * 0.1) + np.random.normal(0, 0.05, len(weeks)), 0, 1)
stress = np.clip(0.4 + 0.3 * np.cos(weeks * 0.1) + np.random.normal(0, 0.05, len(weeks)), 0, 1)
productivity = np.clip(0.5 + 0.4 * np.sin(weeks * 0.15) + np.random.normal(0, 0.05, len(weeks)), 0, 1)

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Normalized Value"

# Labels
label_happiness = "Happiness Score"
label_productivity = "Productivity Index"
label_legend = ["Happiness Score", "Stress Level with Gradient", "Productivity Index"]

# Titles
title = "Societal Metrics Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Plot the happiness score
ax.plot(weeks, happiness, label=label_happiness, color="dodgerblue", marker='o', linewidth=2)

# Plot the stress level with a gradient color
for i in range(len(weeks) - 1):
    ax.plot(
        weeks[i : i + 2],
        stress[i : i + 2],
        linestyle="-",
        linewidth=2,
        color=plt.cm.plasma(i / len(weeks)),
    )

# Plot the productivity index
ax.plot(weeks, productivity, label=label_productivity, color="forestgreen", linestyle="--", linewidth=2)

# Customize the plot with labels, title, and legend
ax.set_title(title, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Add a legend to the plot
custom_lines = [
    plt.Line2D([0], [0], color="dodgerblue", lw=4, marker='o'),
    plt.Line2D([0], [0], color="orange", lw=4),
    plt.Line2D([0], [0], color="forestgreen", lw=4, linestyle="--"),
]
ax.legend(
    custom_lines,
    label_legend,
    fontsize=12,
)

# Add a grid to the plot
ax.set_facecolor("lavenderblush")
ax.grid(True, which="both", linestyle=":", linewidth=0.75, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_257.pdf", bbox_inches="tight")
