
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the plot
weeks = np.arange(1, 29)
temperature = np.clip(
    20 + 5 * np.sin(weeks * 0.2) + np.random.normal(0, 1, len(weeks)), 15, 25
)
precipitation = np.clip(
    50 + 20 * np.cos(weeks * 0.2) + np.random.normal(0, 5, len(weeks)), 30, 70
)
wind_speed = np.clip(
    10 + 3 * np.sin(weeks * 0.3) + np.random.normal(0, 1, len(weeks)), 8, 12
)

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Measurement Units"

# Labels
label_temp = "Temperature (°C)"
label_precip = "Wind Speed (km/h)"
label_legend = ["Temperature (°C)", "Precipitation (mm)", "Wind Speed (km/h)"]

# Titles
title = "Climate Data Trends Across Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Plot the temperature data
ax.plot(weeks, temperature, label=label_temp, color="steelblue", linewidth=3)

# Plot the precipitation data with a gradient color
for i in range(len(weeks) - 1):
    ax.plot(
        weeks[i : i + 2],
        precipitation[i : i + 2],
        linestyle="-",
        linewidth=3,
        color=plt.cm.Greens(i / len(weeks)),
    )

# Plot the wind speed data
ax.plot(weeks, wind_speed, label=label_precip, color="darkorange", linestyle="--", linewidth=3)

# Customize the plot with labels, title, and legend
ax.set_title(title, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Add a legend to the plot
custom_lines = [
    plt.Line2D([0], [0], color="steelblue", lw=4),
    plt.Line2D([0], [0], color="green", lw=4),
    plt.Line2D([0], [0], color="darkorange", lw=4, linestyle="--"),
]
ax.legend(
    custom_lines,
    label_legend,
    fontsize=12,
)

# Add a grid to the plot
ax.set_facecolor("whitesmoke")
ax.grid(True, which="both", linestyle=":", linewidth=0.75, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_258.pdf", bbox_inches="tight")
