
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the new domain - health (average daily steps over months)

months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct']
group_a = [10000, 9800, 10500, 11000, 11500, 12000, 11700, 11900, 11800, 12200]
group_b = [8500, 8700, 8200, 8800, 9000, 9400, 9200, 9600, 9500, 9700]
group_c = [7000, 6900, 7200, 7300, 7500, 7600, 7800, 8000, 7900, 8100]
group_d = [5500, 5700, 5600, 5900, 6000, 6200, 6300, 6400, 6500, 6700]

# Labels and plot types
line_label_group_a = "Group A"
line_label_group_b = "Group B"
line_label_group_c = "Group C"
line_label_group_d = "Group D"

# Plot configuration
xlim_values = [0, 9]  # Months are from 0 to 9
ylim_values = [5000, 13000]
xlabel_value = "Month"
ylabel_value = "Average Daily Steps"
xticks_values = np.arange(0, 10, 1)
yticks_values = np.arange(5000, 13001, 1000)
xtickslabel_values = months
ytickslabel_values = None  # Not explicitly set in the code
title_value = "Average Daily Steps of Different Groups Over 10 Months"
axhiline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))
plt.plot(
    months,
    group_a,
    marker="o",
    markersize=10,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_group_a,
    linewidth=2.5,
    linestyle="-",
)
plt.plot(
    months,
    group_b,
    marker="s",
    markersize=10,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_group_b,
    linewidth=2.5,
    linestyle="--",
)
plt.plot(
    months,
    group_c,
    marker="D",
    markersize=10,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_group_c,
    linewidth=2.5,
    linestyle=":",
)
plt.plot(
    months,
    group_d,
    marker="v",
    markersize=10,
    color="#d62728",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_group_d,
    linewidth=2.5,
    linestyle="-.",
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Customize the x-axis ticks
plt.xticks(xticks_values, xtickslabel_values)
plt.xlim(xlim_values)

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
plt.title(title_value, fontsize=18)
plt.legend(
    frameon=False,
    fontsize=12,
    loc="upper left",
    borderpad=1,
    ncol=1,
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#f0f9e8", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_260.pdf", bbox_inches="tight")
