
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data to mimic educational performance trends
tasks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
math = [85 + np.random.uniform(-5, 5) for _ in tasks]
science = [80 + np.random.uniform(-5, 5) for _ in tasks]
english = [75 + np.random.uniform(-5, 5) for _ in tasks]
history = [70 + np.random.uniform(-5, 5) for _ in tasks]
# Labels and plot types
line_label_math = "Math"
line_label_science = "Science"
line_label_english = "English"
line_label_history = "History"

# Plot configuration
xlim_values = [1, 10]
ylim_values = [60, 90]
xlabel_value = "Tasks"
ylabel_value = "Performance (%)"
xticks_values = np.arange(1, 11, 1)
yticks_values = np.arange(60, 91, 5)
xtickslabel_values = None  # Not explicitly set in the code
ytickslabel_values = None  # Not explicitly set in the code
title_value = "Student Performance Across Different Tasks"
axhiline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))
plt.plot(
    tasks,
    math,
    marker="o",
    markersize=8,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_math,
    linewidth=2,
    linestyle="-",
)
plt.plot(
    tasks,
    science,
    marker="s",
    markersize=8,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_science,
    linewidth=2,
    linestyle="--",
)
plt.plot(
    tasks,
    english,
    marker="D",
    markersize=8,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_english,
    linewidth=2,
    linestyle=":",
)
plt.plot(
    tasks,
    history,
    marker="v",
    markersize=8,
    color="#9467bd",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_history,
    linewidth=2,
    linestyle="-.",
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the x-axis ticks
plt.xticks(xticks_values)  # Ticks from 1 to 10, interval of 1
plt.xlim(xlim_values)  # Slightly beyond 1 and 10 for a margin

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
# Add a title to the plot
plt.title(title_value, fontsize=18)
plt.legend(
    frameon=True,
    fontsize=12,
    loc="upper right",
    borderpad=1,
    ncol=4,
    bbox_to_anchor=(1, 1.2),
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#f7faff", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_262.pdf", bbox_inches="tight")
