
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

years = np.arange(2000, 2011)
christianity = np.linspace(70, 65, 11) + np.random.normal(0, 0.5, 11)
islam = np.linspace(20, 25, 11) + np.random.normal(0, 0.3, 11)
hinduism = np.linspace(5, 6, 11) + np.random.normal(0, 0.2, 11)
non_religious = np.linspace(3, 4, 11) + np.random.normal(0, 0.1, 11)

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(2000, 2011, 1)

ylabel_value = "Affiliation Percentage (%)"
ylim_values = [0, 80]

# Labels
label_Christianity = "Christianity"
label_Islam = "Islam"
label_Hinduism = "Hinduism"
label_NonReligious = "Non-Religious"

# Titles
title_1 = "Religious Affiliation Over Time: Christianity vs Islam"
title_2 = "Religious Affiliation Over Time: Hinduism vs Non-Religious"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Plot the data in each subplot
ax1.plot(
    years,
    christianity,
    marker="s",
    markersize=7,
    color="#1f77b4",
    mfc="w",
    mew=2,
    label=label_Christianity,
    linewidth=2,
    linestyle='-'
)
ax1.plot(
    years,
    islam,
    marker="D",
    markersize=7,
    color="#ff7f0e",
    mfc="w",
    mew=2,
    label=label_Islam,
    linewidth=2,
    linestyle='--'
)
ax1.set_title(title_1, fontsize=10)
ax1.set_xlabel(xlabel_value, fontsize=10)
ax1.set_ylabel(ylabel_value, fontsize=10)
ax1.set_ylim(ylim_values)
ax1.set_xticks(xticks_values)
ax1.legend()
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    years,
    hinduism,
    marker="v",
    markersize=7,
    color="#2ca02c",
    mfc="w",
    mew=2,
    label=label_Hinduism,
    linewidth=2,
    linestyle='-.'
)
ax2.plot(
    years,
    non_religious,
    marker="o",
    markersize=4,
    color="#d62728",
    mfc="w",
    mew=2,
    label=label_NonReligious,
    linewidth=2,
    linestyle=':'
)
ax2.set_title(title_2, fontsize=10)
ax2.set_xlabel(xlabel_value, fontsize=10)
ax2.set_ylabel(ylabel_value, fontsize=10)
ax2.set_ylim(ylim_values)
ax2.set_xticks(xticks_values)
ax2.legend()
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_264.pdf", bbox_inches="tight")
