
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
import numpy as np

np.random.seed(0)
vehicles = np.array([10, 20, 30, 40, 50, 60, 70])
city_traffic_flow = np.clip(
    np.linspace(30, 70, len(vehicles)) + np.random.normal(0, 5, len(vehicles)),
    30,
    80,
)
highway_traffic_flow = np.clip(
    np.linspace(50, 90, len(vehicles)) + np.random.normal(0, 7, len(vehicles)),
    50,
    100,
)

# Axes Limits and Labels
xlabel_value = "Number of Vehicles"

ylabel_value_1 = "City Traffic Flow (vehicles/hour)"
ylabel_value_2 = "Highway Traffic Flow (vehicles/hour)"

# Labels
label_1 = "City Traffic Flow"
label_2 = "Highway Traffic Flow"

# Threshold Label
label = "Flow Threshold"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

(city_flow_line,) = ax.plot(
    vehicles,
    city_traffic_flow,
    "o-",
    color="#1a9641",
    label=label_1,
    markersize=8,
    linewidth=2,
)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value_1, fontsize=12)
ax.tick_params(axis="y", direction="in", labelsize=10)
ax.tick_params(axis="x", direction="in", labelsize=10)

# Create a secondary y-axis for Highway Traffic Flow
(highway_flow_line,) = ax.plot(
    vehicles,
    highway_traffic_flow,
    "s--",
    color="#3288bd",
    label=label_2,
    markersize=8,
    linewidth=2,
)

# Add a legend to the plot
threshold = 75
ax.axhline(y=threshold, color="red", linestyle="-", linewidth=1.5, label=label)

# Highlight the data points above the threshold
highlight = [40, 60]  # Vehicles to highlight
for veh in highlight:
    ax.plot(
        veh, city_traffic_flow[np.where(vehicles == veh)], "ro"
    )  # Highlight City Traffic Flow
    ax.annotate(
        f"Highlight {veh}",
        (veh, city_traffic_flow[np.where(vehicles == veh)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
ax.legend()

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_275.pdf", bbox_inches="tight")
