
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
import numpy as np

np.random.seed(0)

# Age groups in decades (20s, 30s, 40s, 50s, 60s, 70s, 80s)
age_groups = np.array([20, 30, 40, 50, 60, 70, 80])

# Simulated engagement and satisfaction scores
engagement_score = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.1, len(age_groups)),
    0.2,
    0.9,
)
satisfaction_score = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.1, len(age_groups)),
    0.3,
    1,
)

# Axes Limits and Labels
xlabel_value = "Age Group"
ylabel_value_1 = "Engagement Score"
ylabel_value_2 = "Satisfaction Score"

# Labels
label_1 = "Engagement Score"
label_2 = "Satisfaction Score"
label = "Average Engagement"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot Engagement Score
(engagement_line,) = ax.plot(
    age_groups,
    engagement_score,
    "o-",
    color="#1f77b4",
    label=label_1,
    markersize=8,
    linewidth=2,
)

ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value_1, fontsize=12)
ax.tick_params(axis="y", direction="in", labelsize=10)
ax.tick_params(axis="x", direction="in", labelsize=10)

# Plot Satisfaction Score
(satisfaction_line,) = ax.plot(
    age_groups,
    satisfaction_score,
    "s--",
    color="#ff7f0e",
    label=label_2,
    markersize=8,
    linewidth=2,
)

# Add a horizontal line for average engagement score
avg_engagement = np.mean(engagement_score)
ax.axhline(y=avg_engagement, color="green", linestyle="-", linewidth=1.5, label=label)

# Highlight specific age groups with significant scores
highlight = [30, 50, 70]
for group in highlight:
    ax.plot(
        group, engagement_score[np.where(age_groups == group)], "ro"
    )  # Highlight Engagement Score
    ax.annotate(
        f"Age {group}s",
        (group, engagement_score[np.where(age_groups == group)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
ax.legend()

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_277.pdf", bbox_inches="tight")

