
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
time_points = np.array([1, 2, 3, 4, 5, 6, 7])
social_media_success = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(time_points))) + np.random.normal(0, 0.2, len(time_points)),
    0.2,
    0.9,
)
email_campaign_success = np.clip(
    np.cos(np.linspace(0, 3 * np.pi, len(time_points))) + np.random.normal(0, 0.4, len(time_points)),
    0.3,
    1,
)
television_campaign_success = np.clip(
    np.sin(np.linspace(0, 4 * np.pi, len(time_points))) + np.random.normal(0, 0.3, len(time_points)),
    0.1,
    0.8,
)
highlight = [3, 5, 6]

# Axes Limits and Labels
xlabel_value = "Time Points"
ylabel_value_1 = "Social Media Success Rate (%)"
ylabel_value_2 = "Email Campaign Success Rate (%)"
ylabel_value_3 = "Television Campaign Success Rate (%)"

# Labels
label_1 = "Social Media"
label_2 = "Threshold"
label_3 = "Email Campaign"
label_4 = "Television Campaign"


# Additional Parameters
highlight_annotation = "Above Threshold"
supertitle_value = "Media Campaign Success Rates Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 1x3 grid
fig, axs = plt.subplots(1, 3, figsize=(18, 6), sharey=True)

# Colors
color_1 = "#1f78b4"  # Blue
color_2 = "#33a02c"  # Green
color_3 = "#e31a1c"  # Red
threshold_color = "#ff7f00"  # Orange
# Plot the Social Media data
axs[0].plot(
    time_points,
    social_media_success,
    "o-",
    color=color_1,
    label=label_1,
    markersize=8,
    linewidth=2,
)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value_1, fontsize=12)
axs[0].tick_params(axis="y", direction="in", labelsize=10)
axs[0].tick_params(axis="x", direction="in", labelsize=10)

# Plot the Email Campaign data
axs[1].plot(
    time_points,
    email_campaign_success,
    "s--",
    color=color_2,
    label=label_3,
    markersize=8,
    linewidth=2,
)
axs[1].set_xlabel(xlabel_value, fontsize=12)

# Plot the Television Campaign data
axs[2].plot(
    time_points,
    television_campaign_success,
    "d-.",
    color=color_3,
    label=label_4,
    markersize=8,
    linewidth=2,
)
axs[2].set_xlabel(xlabel_value, fontsize=12)

# Add a threshold line to all plots
threshold = 0.7
for ax in axs:
    ax.axhline(y=threshold, color=threshold_color, linestyle="-", linewidth=1.5, label=label_2)

# Highlight the data points above the threshold
for ax in axs:
    for tp in highlight:
        y_vals = []
        if ax == axs[0]:
            y_vals = social_media_success
        elif ax == axs[1]:
            y_vals = email_campaign_success
        else:
            y_vals = television_campaign_success
        
        ax.plot(
            tp, y_vals[np.where(time_points == tp)], "ro"
        )  # Highlight data points
        ax.annotate(
            highlight_annotation,
            (tp, y_vals[np.where(time_points == tp)]),
            textcoords="offset points",
            xytext=(0, -20),
            ha="center",
        )

# Customize legends and grid
for ax in axs:
    ax.legend()
    ax.grid(True, linestyle="--", alpha=0.6)

# Super Title for the figure
fig.suptitle(supertitle_value, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_279.pdf", bbox_inches="tight")
