
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data (example values, the actual data should be extracted from the paper)
years = [2000, 2005, 2010, 2015, 2020]
gdp_country_a = [2.5, 3.0, 2.8, 2.6, 3.1]
gdp_country_b = [1.8, 2.0, 1.9, 2.1, 2.3]
gdp_country_c = [2.0, 2.5, 2.3, 2.8, 3.0]
gdp_country_d = [1.5, 1.8, 1.7, 2.0, 1.9]

# Labels and Plot Types
label_country_a = "Country A"
label_country_b = "Country B"
label_country_c = "Country C"
label_country_d = "Country D"

# Axes Limits and Labels
xlim_values = [2000, 2020]
ylim_values = [1, 4]
xlabel_value = "Year"
ylabel_value = "GDP Growth Rate (%)"
xticks_values = np.arange(2000, 2021, 5)
yticks_values = np.arange(1, 4.5, 0.5)
xtickslabel_values = None  # Not specified in the code
ytickslabel_values = None  # Not specified in the code
title_value = "GDP Growth Rate Over Time"
axhiline_value = None  # Not specified in the code
axvline_value = None  # Not specified in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    gdp_country_a,
    "-o",
    label=label_country_a,
    color="#4daf4a",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    gdp_country_b,
    "-^",
    label=label_country_b,
    color="#377eb8",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    gdp_country_c,
    "-s",
    label=label_country_c,
    color="#ff7f00",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    gdp_country_d,
    "-d",
    label=label_country_d,
    color="#e41a1c",
    clip_on=False,
    zorder=10,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=4, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjusting layout to give space for the title
plt.savefig("line_71.pdf", bbox_inches="tight")
