
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
snr_values = [5, 10, 15, 20, 25]
approach_a = [12, 35, 55, 75, 95]
approach_b = [10, 28, 50, 70, 90]
approach_c = [8, 25, 45, 65, 85]
our_approach = [15, 40, 60, 80, 98]

# Labels and Plot Types
label_approach_a = "Approach A"
label_approach_b = "Approach B"
label_approach_c = "Approach C"
label_our_approach = "Our Approach"

# Axes Limits and Labels
xlim_values = [5, 25]
ylim_values = [0, 100]
xlabel_value = "SNR (dB)"
ylabel_value = "Classification Accuracy (%)"
xticks_values = np.arange(5, 30, 5)
yticks_values = np.arange(0, 101, 20)
title_value = "Classification Accuracy vs SNR for Different Approaches"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.plot(
    snr_values,
    approach_a,
    linestyle='--',
    marker='o',
    label=label_approach_a,
    color="tomato",
    clip_on=False,
    zorder=10,
)
plt.plot(
    snr_values,
    approach_b,
    linestyle='-.',
    marker='^',
    label=label_approach_b,
    color="royalblue",
    clip_on=False,
    zorder=10,
)
plt.plot(
    snr_values,
    approach_c,
    linestyle=':',
    marker='s',
    label=label_approach_c,
    color="green",
    clip_on=False,
    zorder=10,
)
plt.plot(
    snr_values,
    our_approach,
    linestyle='-',
    marker='x',
    label=label_our_approach,
    color="purple",
    clip_on=False,
    zorder=10,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_73.pdf", bbox_inches="tight")

