
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
days = [0, 10, 20, 30, 40]  # 5 data points representing days in a month
stock_A = [100, 110, 105, 115, 120]  # Stock A prices in USD
stock_B = [95, 102, 108, 107, 115]  # Stock B prices in USD
stock_C = [98, 99, 101, 103, 106]  # Stock C prices in USD

# Simulating standard deviations for error
stock_A_std = np.random.rand(5) * 2
stock_B_std = np.random.rand(5) * 2
stock_C_std = np.random.rand(5) * 2

# Labels
label_Stock_A = "Stock A"
label_Stock_B = "Stock B"
label_Stock_C = "Stock C"

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Stock Prices (in USD)"
yticks_values = np.arange(90, 130, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(4, 3))

# Stock A
plt.plot(days, stock_A, "o-", color="#0077b6", label=label_Stock_A)
plt.fill_between(days, stock_A - stock_A_std, stock_A + stock_A_std, color="#0077b6", alpha=0.2)

# Stock B
plt.plot(days, stock_B, "s--", color="#90be6d", label=label_Stock_B)
plt.fill_between(days, stock_B - stock_B_std, stock_B + stock_B_std, color="#90be6d", alpha=0.2)

# Stock C
plt.plot(days, stock_C, "d-.", color="#f94144", label=label_Stock_C)
plt.fill_between(days, stock_C - stock_C_std, stock_C + stock_C_std, color="#f94144", alpha=0.2)

# x labels
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(days)
plt.yticks(yticks_values)
plt.title("Stock Prices Over Time")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# Legend
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("line_76.pdf", bbox_inches="tight")
