
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for Technology Adoption Rates
years = np.array(["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"])
tech_a_adoption = np.array([20, 30, 45, 55, 65, 75, 80, 85])
tech_a_err = np.array([2, 3, 2, 4, 3, 3, 2, 3])

tech_b_adoption = np.array([15, 25, 35, 50, 60, 68, 73, 78])
tech_b_err = np.array([3, 2, 3, 4, 3, 2, 3, 2])

# Labels
label_tech_a = "Tech-A Adoption"
label_tech_b = "Tech-B Adoption"
title = "Technology Adoption Rates Over Time"
xlabel_value = "Year"
ylabel_value = "Adoption Rate (%)"
legend_location = "upper left"

# Axes Limits and Labels
yticks_values = np.arange(0, 101, 20)
ylim_values = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))

plt.errorbar(
    years,
    tech_a_adoption,
    yerr=tech_a_err,
    fmt="o-",
    label=label_tech_a,
    color="#1f77b4",
    capsize=5,
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    tech_b_adoption,
    yerr=tech_b_err,
    fmt="--",
    label=label_tech_b,
    color="#2ca02c",
    marker="s",
    capsize=5,
    linewidth=2,
    markersize=8
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# Set x-axis label to be rotated and styled
plt.xticks(rotation=45, fontsize=12)

# Adding labels and title
plt.title(title, fontsize=18)
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.legend(loc=legend_location, fontsize=14)

# Adjusting figure size
plt.gcf().set_size_inches(10, 6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_77.pdf", bbox_inches="tight")
