
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for stock performance
stock_x = np.array([
    "Q1 2022", "Q2 2022", "Q3 2022", "Q4 2022", 
    "Q1 2023", "Q2 2023", "Q3 2023", "Q4 2023"
])
stock_y = np.array([85, 87, 88, 86, 90, 92, 93, 91])
stock_err = np.array([2, 3, 2, 1, 2, 3, 2, 1])

# Data for cryptocurrency performance
crypto_x = np.array([
    "Q1 2022", "Q2 2022", "Q3 2022", "Q4 2022", 
    "Q1 2023", "Q2 2023", "Q3 2023", "Q4 2023"
])
crypto_y = np.array([78, 80, 81, 79, 83, 85, 86, 84])
crypto_err = np.array([3, 2, 3, 2, 3, 2, 3, 2])

# Labels for the chart
label_stock = "Stock Performance"
label_crypto = "Crypto Performance"
xlabel_value = "Quarters"
ylabel_value = "Performance Score"

# Axes Limits and Labels
yticks_values = np.arange(70, 101, 5)
ylim_values = [70, 100]

title="Quarterly Financial Performance"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(
    figsize=(10, 5)
)

plt.errorbar(
    stock_x,
    stock_y,
    yerr=stock_err,
    fmt="o-",
    label=label_stock,
    color="#2c7bb6",  # Deep blue
    capsize=5,
)

plt.errorbar(
    crypto_x,
    crypto_y,
    yerr=crypto_err,
    fmt="--",
    label=label_crypto,
    color="#d7191c",  # Deep red
    marker="s",
    capsize=5,
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=16)
plt.ylim(ylim_values)

# set x-axis label to be rotated
plt.xticks(rotation=45, fontsize=12)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)
plt.legend(loc="upper left", fontsize=16)

# Adjusting figure size to match the original image's dimensions
plt.gcf().set_size_inches(10, 5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_78.pdf", bbox_inches="tight")

