
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for 2022 smartphone sales (in millions)
brands = np.array(["Brand A", "Brand B", "Brand C", "Brand D", "Brand E", "Brand F"])
sales_2022 = np.array([75, 90, 55, 65, 80, 50])
err_2022 = np.array([5, 4, 6, 3, 4, 5])

# Data for 2023 smartphone sales (in millions)
sales_2023 = np.array([80, 95, 60, 70, 85, 55])
err_2023 = np.array([6, 5, 4, 4, 5, 6])

# Labels
label_2022 = "Sales 2022"
label_2023 = "Sales 2023"

# Axes Limits and Labels
ylabel_value = "Sales (in millions)"
xlabel_value = "Smartphone Brands"
title_value = "Smartphone Sales by Brand (2022 vs 2023)"
yticks_values = np.arange(40, 101, 10)
ylim_values = [40, 105]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(12, 6))  # Adjusting figure size

plt.errorbar(
    brands,
    sales_2022,
    yerr=err_2022,
    fmt="o-",
    label=label_2022,
    color="#1f77b4",  # Modern color for 2022 sales
    capsize=5,
    linewidth=2,
    markersize=8,
)

plt.errorbar(
    brands,
    sales_2023,
    yerr=err_2023,
    fmt="s--",
    label=label_2023,
    color="#ff7f0e",  # Modern color for 2023 sales
    capsize=5,
    linewidth=2,
    markersize=8,
)

# Set x, y-axis to display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)
plt.xticks(rotation=45, fontsize=14)

# Adding labels and title
plt.ylabel(ylabel_value, fontsize=16)
plt.xlabel(xlabel_value, fontsize=16)
plt.title(title_value, fontsize=18)
plt.legend(loc="upper left", fontsize=14)

# Adjusting layout to reduce white space
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_79.pdf", bbox_inches="tight")
