
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
age_groups = ["10-20", "21-30", "31-40", "41-50"]  # Update for categorical x-axis
happiness_baseline = [70, 75, 65, 60]
happiness_stress_reduction = [85, 80, 75, 70]
stress_baseline = [50, 55, 60, 65]
stress_stress_reduction = [30, 35, 40, 45]

# Axes Limits and Labels
xticks_values = range(len(age_groups))
ylabel_value = "Level (%)"
xlabel_value = "Age Groups"

# Labels
label_1 = "Baseline"
label_2 = "Post Stress Reduction"

# Titles
title_1 = "Happiness Levels"
title_2 = "Stress Levels"
supertitle = "Psychological Well-being Across Age Groups"

# Texts
text_1 = "Increase +15%"
text_2 = "Decrease -20%"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Plotting for Happiness Levels
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    age_groups,
    happiness_baseline,
    marker="o",
    color="#1f77b4",
    label=label_1,
    linewidth=4,
    markersize=8,
)
ax1.plot(
    age_groups,
    happiness_stress_reduction,
    marker="o",
    linestyle="--",
    color="#1f77b4",
    label=label_2,
    linewidth=4,
    markersize=8,
)
ax1.set_title(title_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=16)  # Adjusted font size
ax1.legend(loc="lower right", fontsize=14)
ax1.set_xticklabels(age_groups, fontsize=12)  # Adjust font size for x-axis labels
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    "",
    xy=(0, happiness_baseline[0]),
    xytext=(0, happiness_stress_reduction[0]),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax1.text(
    0.1,
    (happiness_baseline[0] + happiness_stress_reduction[0]) / 2,
    text_1,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# Plotting for Stress Levels
ax2.plot(
    age_groups,
    stress_baseline,
    marker="o",
    color="#ff7f0e",
    label=label_1,
    linewidth=4,
    markersize=8,
)
ax2.plot(
    age_groups,
    stress_stress_reduction,
    marker="o",
    linestyle="--",
    color="#ff7f0e",
    label=label_2,
    linewidth=4,
    markersize=8,
)
ax2.set_title(title_2, fontsize=16)  # Adjusted font size
ax2.legend(loc="upper left", fontsize=14)
ax2.set_xticklabels(age_groups, fontsize=12)  # Ensure x-axis labels are set for both axes
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    "",
    xy=(0, stress_baseline[0]),
    xytext=(0, stress_stress_reduction[0]),
    arrowprops=dict(color="red", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax2.text(
    0.1,
    (stress_baseline[0] + stress_stress_reduction[0]) / 2,
    text_2,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for resolution
plt.suptitle(supertitle, fontsize=18, weight='bold')
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("line_81.pdf", bbox_inches="tight")
