
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data (Agriculture domain)
years = list(range(2010, 2021))
yield_corn = [2.5, 2.7, 2.8, 3.0, 3.1, 3.5, 3.6, 3.7, 4.0, 4.1, 4.3]
yield_wheat = [2.0, 2.1, 2.3, 2.4, 2.5, 2.6, 2.8, 2.9, 3.0, 3.1, 3.2]
yield_soybeans = [1.8, 1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8]

# Labels and Plot Types
label_corn = "Corn Yield"
label_wheat = "Wheat Yield"
label_soybeans = "Soybeans Yield"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Yield (tons/hectare)"
xlim_values = [2009, 2021]
ylim_values = [1.5, 4.5]
xticks_values = range(2010, 2021, 1)
yticks_values = np.arange(1.5, 4.6, 0.5)
title="Crop Yield Over Time"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 5))  # Adjusting figure size for better readability
plt.plot(
    years, yield_corn, "o-", label=label_corn, color="#4CAF50", linewidth=2, markersize=6
)
plt.plot(
    years,
    yield_wheat,
    "s-",
    label=label_wheat,
    color="#FFB74D",
    linewidth=2,
    markersize=6
)
plt.plot(
    years,
    yield_soybeans,
    "d-",
    label=label_soybeans,
    color="#8D6E63",
    linewidth=2,
    markersize=6
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)

# Adjusting x and y axis limits to add some space before the start and after the end
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values, fontsize=12)  # X-axis from 2010 to 2020 with a step of 1
plt.yticks(yticks_values, fontsize=12)  # Y-axis from 1.5 to 4.5 with a step of 0.5

# Adding legend outside the plot area
plt.legend(loc="upper left", fancybox=True, shadow=False, fontsize=12)

# Adding semi-transparent grid for better readability
plt.grid(True, which="major", linewidth=0.5, alpha=0.5)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_85.pdf", bbox_inches="tight")
