
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for finance domain
n_aug = ["0", "0.125", "0.25", "0.5", "1", "2", "4", "8"]
returns = [1, 2, 3, 5, 7, 6, 4, 3]
risk = [7, 6, 5, 4, 3, 2, 1, 0.5]
liquidity = [2, 2.5, 3, 2.8, 2.5, 2, 1.5, 1]

# Positions for the bars on the x-axis
ind = np.arange(len(n_aug))

# Labels and Legend
xlabel = "Investment Level"
ylabel = "Performance Metrics"
returns_label = "Returns"
risk_label = "Risk"
liquidity_label = "Liquidity"

# Limits
xlim = (n_aug[0], n_aug[-1])
ylim = (0, 8)
title="Financial Performance Metrics by Investment Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust the size to match the original image's dimensions
ax.plot(n_aug, returns, label=returns_label, color="#2ca02c", linestyle='-', marker='o', linewidth=2)
ax.plot(n_aug, risk, label=risk_label, color="#d62728", linestyle='--', marker='s', linewidth=2)
ax.plot(n_aug, liquidity, label=liquidity_label, color="#1f77b4", linestyle=':', marker='^', linewidth=2)

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 8
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of n_aug without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, fontweight='bold')

# Legend
ax.legend(loc="upper center", fontsize=14, frameon=False, ncol=3, bbox_to_anchor=(0.5, 1.15))

# Grid
ax.grid(True, ls="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_98.pdf", bbox_inches="tight")
