
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate sample data for the histogram representing crop yields
wheat_yields = np.random.normal(loc=200, scale=50, size=1000)  # Wheat yields in kg/ha
corn_yields = np.random.normal(loc=150, scale=40, size=1000)   # Corn yields in kg/ha

# Generate sample data for the scatter plot representing soil characteristics
soil_ph = np.random.uniform(4.5, 8.5, 100)
nitrogen_content = np.random.normal(20, 5, 100)  # Nitrogen in mg/kg
phosphorus_content = np.random.normal(15, 4, 100)  # Phosphorus in mg/kg

ax1title = "Histogram of Crop Yields"
ax1xlabel = "Yield (kg/ha)"
ax1ylabel = "Frequency"
ax1legend = ["Wheat", "Corn"]
ax2title = "Soil Characteristics"
ax2labels = ["pH vs Nitrogen", "pH vs Phosphorus"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram for crop yields
# Create a figure and a 1x2 grid layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

ax1 = fig.add_subplot(gs[0, 0])
ax1.hist(
    [wheat_yields, corn_yields], bins=50, stacked=True, color=["#7fc97f", "#beaed4"], alpha=0.7
)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for soil characteristics
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(soil_ph, nitrogen_content, c="#fdc086", label=ax2labels[0], marker='^')
ax2.scatter(soil_ph, phosphorus_content, c="#386cb0", label=ax2labels[1], marker='o')
ax2.set_title(ax2title)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_32.pdf", bbox_inches="tight")
