
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for the histogram representing sales performance
profits = np.random.normal(loc=0.2, scale=0.1, size=1000)  # Average profit of 20% with 10% variance
losses = np.random.normal(loc=-0.1, scale=0.1, size=1000)  # Average loss of 10% with 10% variance

# Generate sample data for the scatter plot representing sales clusters
x = np.random.uniform(0, 100, 100)
sales_region_a = np.random.normal(60, 10, 100)
sales_region_b = np.random.normal(40, 10, 100)

ax1title = "Histogram of Sales Performance"
ax1xlabel = "Sales Performance"
ax1ylabel = "Frequency"
ax1legend = ["Profits", "Losses"]
ax2title = "Sales Clusters by Region"
ax2labels = ["Region A", "Region B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a 1x2 grid layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# Histogram for sales performance
ax1 = fig.add_subplot(gs[0, 0])
ax1.hist([profits, losses], bins=50, stacked=True, color=["#1f77b4", "#ff7f0e"], alpha=0.7)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for sales clusters
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(x, sales_region_a, c="#2ca02c", marker="o", label=ax2labels[0])
ax2.scatter(x, sales_region_b, c="#d62728", marker="^", label=ax2labels[1])
ax2.set_title(ax2title)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_33.pdf", bbox_inches="tight")
