
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic data for student performance over time
def student_performance(t):
    return np.sin(2 * np.pi * t) * np.exp(-t/2)

years = np.arange(0.0, 5.0, 0.1)
months = np.arange(0.0, 5.0, 0.02)
weeks = np.arange(0.0, 2.0, 0.01)

# Generate synthetic geographic data for school distribution
X = np.arange(-5, 5, 0.25)
Y = np.arange(-5, 5, 0.25)
X, Y = np.meshgrid(X, Y)
R = np.sqrt(X**2 + Y**2)
Z = np.sin(R)

# Axes Limits and Labels
ylabel_value_1 = "Student Performance Score"
xlabel_value_1 = "Time (Years)"

zlim_values = [-1, 1]
xlabel_value_2 = "Longitude"
ylabel_value_2 = "Latitude"
zlabel_value_2 = "School Density"

# Additional label and legend settings
title_1 = "Student Performance Over Time"
title_2 = "Geographical Distribution of Schools"
legend_labels = ["Annual", "Monthly"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up a figure twice as tall as it is wide
fig = plt.figure(figsize=(8, 10))

# First subplot
ax1 = fig.add_subplot(2, 1, 1)
ax1.plot(years, student_performance(years), 'o', color='darkblue', markerfacecolor='red', label=legend_labels[0])
ax1.plot(months, student_performance(months), '--', color='orange', markerfacecolor='green', label=legend_labels[1])
ax1.grid(True)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xlabel(xlabel_value_1)
ax1.set_title(title_1)
ax1.legend()

# Second subplot
ax2 = fig.add_subplot(2, 1, 2, projection="3d")
surf = ax2.plot_surface(X, Y, Z, rstride=1, cstride=1, linewidth=0, antialiased=False, cmap='viridis')
ax2.set_zlim(zlim_values)
ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)
ax2.set_zlabel(zlabel_value_2)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show the plot
plt.savefig("multidiff_36.pdf", bbox_inches="tight")
