
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing necessary library
import numpy as np

np.random.seed(42)

# Regions for the plots
regions1 = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Oceania",
]
regions2 = [
    "Africa",
    "Asia",
    "Europe",
    "North America",
    "Oceania",
    "South America",
]

# Population data (in millions)
population = [579.3, 741.4, 4458.5, 422.5, 1216.0, 41.3]
urban_population = [319.8, 543.2, 2395.7, 319.0, 472.3, 30.5]

# Population differences (in millions)
population_diff = np.array(
    [
        [0, -162.1, -3879.2, 156.8, -636.7, 538.0],
        [162.1, 0, -3717.1, 318.9, -474.6, 700.1],
        [3879.2, 3717.1, 0, 4036.0, 3242.5, 4417.2],
        [-156.8, -318.9, -4036.0, 0, -793.5, 381.2],
        [636.7, 474.6, -3242.5, 793.5, 0, 1174.7],
        [-538.0, -700.1, -4417.2, -381.2, -1174.7, 0],
    ]
)
urban_population_diff = np.array(
    [
        [0, -223.4, -2075.9, 0.8, -152.5, 289.3],
        [223.4, 0, -1852.5, 224.2, 70.9, 512.7],
        [2075.9, 1852.5, 0, 2076.7, 1923.4, 2365.2],
        [-0.8, -224.2, -2076.7, 0, -153.3, 289.4],
        [152.5, -70.9, -1923.4, 153.3, 0, 442.7],
        [-289.3, -512.7, -2365.2, -289.4, -442.7, 0],
    ]
)
population_growth_rate = np.array(
    [
        [0, 0.5, -0.9, 1.4, 0.8, 1.6],
        [-0.5, 0, -1.4, 0.9, 0.3, 1.1],
        [0.9, 1.4, 0, 2.3, 1.1, 2.5],
        [-1.4, -0.9, -2.3, 0, -1.2, 0.2],
        [-0.8, -0.3, -1.1, 1.2, 0, 1.3],
        [-1.6, -1.1, -2.5, -0.2, -1.3, 0],
    ]
)
urban_growth_rate = np.array(
    [
        [0, 0.8, -1.0, 1.5, 0.9, 1.8],
        [-0.8, 0, -1.6, 1.0, 0.4, 1.2],
        [1.0, 1.6, 0, 2.4, 1.3, 2.6],
        [-1.5, -1.0, -2.4, 0, -1.3, 0.3],
        [-0.9, -0.4, -1.3, 1.3, 0, 1.4],
        [-1.8, -1.2, -2.6, -0.3, -1.4, 0],
    ]
)
titles = [
    "Total Population (millions)",
    "Urban Population (millions)",
    "Population Diff. (millions)",
    "Urban Population Diff. (millions)",
    "Population Growth Rate (%)",
    "Urban Growth Rate (%)",
]
xlim1 = [0, 5000]
xlim2 = [0, 3000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(12, 8))

# Plot Total Population
axs[0, 0].barh(regions1, population, color="#66c2a5")
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()
# annotate the bars with the values
for i, v in enumerate(population):
    axs[0, 0].text(v + 10, i, str(v), color="black", va="center")

# Plot Urban Population
axs[1, 0].barh(regions2, urban_population, color="#fc8d62")
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()
# annotate the bars with the values
for i, v in enumerate(urban_population):
    axs[1, 0].text(v + 10, i, str(v), color="black", va="center")

# Plot Population Diff.
im1 = axs[0, 1].imshow(population_diff, cmap="coolwarm", aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(regions1)):
    for j in range(len(regions1)):
        text = axs[0, 1].text(
            j,
            i,
            population_diff[i, j],
            ha="center",
            va="center",
            color="black" if abs(population_diff[i, j]) < 2000 else "white",
        )
axs[0, 1].axis("off")

# Plot Urban Population Diff.
im2 = axs[1, 1].imshow(urban_population_diff, cmap="coolwarm", aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(regions2)):
    for j in range(len(regions2)):
        text = axs[1, 1].text(
            j,
            i,
            urban_population_diff[i, j],
            ha="center",
            va="center",
            color="black" if abs(urban_population_diff[i, j]) < 2000 else "white",
        )
axs[1, 1].axis("off")

# Plot Population Growth Rate
im3 = axs[0, 2].imshow(population_growth_rate, cmap="YlGnBu", aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(regions1)):
    for j in range(len(regions1)):
        text = axs[0, 2].text(
            j,
            i,
            population_growth_rate[i, j],
            ha="center",
            va="center",
            color="black" if abs(population_growth_rate[i, j]) < 1.5 else "white",
        )
axs[0, 2].axis("off")

# Plot Urban Growth Rate
im4 = axs[1, 2].imshow(urban_growth_rate, cmap="YlOrBr", aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(regions2)):
    for j in range(len(regions2)):
        text = axs[1, 2].text(
            j,
            i,
            urban_growth_rate[i, j],
            ha="center",
            va="center",
            color="black" if abs(urban_growth_rate[i, j]) < 1.5 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_44.pdf", bbox_inches="tight")
