
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Assuming data values for the bar chart
platforms = [
    "Netflix",
    "Hulu",
    "Disney+",
    "Amazon Prime",
    "HBO Max",
    "Apple TV+",
]
ratings = [4.5, 4.0, 3.8, 4.1, 3.7, 3.5]

# Generate y values for the line chart with a trend over 26 weeks
weeks = np.arange(26)
netflix_ratings = np.linspace(4.5, 4.0, 26) + np.random.normal(0, 0.1, 26)
hulu_ratings = np.linspace(4.0, 3.9, 26) + np.random.normal(0, 0.05, 26)
disney_ratings = np.linspace(3.8, 4.2, 26) + np.random.normal(0, 0.1, 26)
prime_ratings = np.linspace(4.1, 4.3, 26) + np.random.normal(0, 0.05, 26)
hbo_ratings = np.linspace(3.7, 3.6, 26) + np.random.normal(0, 0.05, 26)
apple_tv_ratings = np.linspace(3.5, 4.0, 26) + np.random.normal(0, 0.1, 26)

# Axes Limits and Labels
xlabel_value_1 = "Average Viewer Rating"
xlim_values_1 = [0, 5]
xticks_all_1 = np.arange(0, 5.05, 0.25)
xticks_labeled_1 = np.arange(0, 5.1, 1)

xlabel_value_2 = "Weeks"
ylabel_value_2 = "Avg. Rating"
ylim_values_2 = [3.0, 5]
xticks_all_2 = np.arange(0, 26, 1)
xticks_labeled_2 = np.arange(0, 26, 5)

# Labels for line chart
label_Netflix = "Netflix"
label_Hulu = "Hulu"
label_Disney = "Disney+"
label_Prime = "Amazon Prime"
label_HBO = "HBO Max"
label_AppleTV = "Apple TV+"

title=["Average Viewer Rating for Streaming Platforms", "Viewer Ratings Over Time for Streaming Platforms"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
bar_colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99','#c2c2f0','#ffb3e6']
ax1.barh(platforms, ratings, color=bar_colors)
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)
ax1.set_title(title[0])

# Create line chart
ax2.plot(weeks, netflix_ratings, label=label_Netflix, color="#ff9999", linestyle='-')
ax2.plot(weeks, hulu_ratings, label=label_Hulu, color="#66b3ff", linestyle='--')
ax2.plot(weeks, disney_ratings, label=label_Disney, color="#99ff99", linestyle='-.')
ax2.plot(weeks, prime_ratings, label=label_Prime, color="#ffcc99", linestyle=':')
ax2.plot(weeks, hbo_ratings, label=label_HBO, color="#c2c2f0", linestyle=(0, (3, 1, 1, 1)))
ax2.plot(weeks, apple_tv_ratings, label=label_AppleTV, color="#ffb3e6", linestyle='-')

ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)
ax2.set_title(title[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_48.pdf", bbox_inches="tight")
