
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Assuming data values for the bar chart
categories = [
    "Adventure",
    "Cultural",
    "Eco-tourism",
    "Beach",
    "Mountain",
    "City",
]
values = [0.85, 0.75, 0.65, 0.70, 0.55, 0.45]

# Generate y values for the line chart with simulated yearly visitor counts
years = np.arange(2013, 2023)
adventure_visitors = np.linspace(1.5, 0.8, 10) + np.random.normal(0, 0.1, 10)
cultural_visitors = np.linspace(1.2, 0.7, 10) + np.random.normal(0, 0.1, 10)
eco_tourism_visitors = np.linspace(1.1, 0.6, 10) + np.random.normal(0, 0.1, 10)
beach_visitors = np.linspace(1.4, 0.9, 10) + np.random.normal(0, 0.1, 10)
mountain_visitors = np.linspace(1.0, 0.5, 10) + np.random.normal(0, 0.1, 10)
city_visitors = np.linspace(0.9, 0.4, 10) + np.random.normal(0, 0.1, 10)

# Axes Limits and Labels
xlabel_value_1 = "Popularity Score"
xlim_values_1 = [0, 1]
xticks_all_1 = np.arange(0, 1.05, 0.05)
xticks_labeled_1 = np.arange(0, 1.1, 0.2)

xticks_2 = np.arange(2013, 2023)
label_Adventure = "Adventure"
label_Cultural = "Cultural"
label_Eco_Tourism = "Eco-tourism"
label_Beach = "Beach"
label_Mountain = "Mountain"
label_City = "City"
xlabel_value_2 = "Year"
ylabel_value_2 = "Visitor Count (millions)"
ylim_values_2 = [0, 2]
xticks_all_2 = np.arange(2013, 2023, 1)
xticks_labeled_2 = np.arange(2013, 2023, 2)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
ax1.barh(categories, values, color=["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"])
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# Create line chart
ax2.plot(years, adventure_visitors, label=label_Adventure, color="skyblue", marker='o')
ax2.plot(years, cultural_visitors, label=label_Cultural, color="coral", marker='s')
ax2.plot(years, eco_tourism_visitors, label=label_Eco_Tourism, color="forestgreen", marker='x')
ax2.plot(years, beach_visitors, label=label_Beach, color="gold", linestyle="--", marker='D')
ax2.plot(years, mountain_visitors, label=label_Mountain, color="darkred", linestyle=":", marker='^')
ax2.plot(years, city_visitors, label=label_City, color="darkorchid", linestyle="-.", marker='v')
ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit to match the uploaded image aspect
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_49.pdf", bbox_inches="tight")
