
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the bar chart
models = [
    "Model A (M1)",
    "Model B (M2)",
    "Model C (M3)",
    "Model D (M4)",
    "Model E (M5)",
    "Model F (M6)",
    "Model G (M7)",
]
publication_count = [120, 95, 150, 110, 100, 130, 140]

# Data for the heatmap (Citation Matrix)
citations = np.array(
    [
        [0, 10, 20, 10, 5, 15, 25],
        [5, 0, 15, 10, 10, 20, 30],
        [10, 20, 0, 25, 15, 35, 40],
        [15, 10, 20, 0, 15, 25, 20],
        [5, 15, 20, 10, 0, 10, 15],
        [10, 25, 30, 20, 15, 0, 35],
        [20, 30, 40, 25, 35, 30, 0],
    ]
)

# Text Labels
ax1title = "Publications Count"
ax2title = "Citation Matrix"
ax1xlim = [0, 160]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(12, 7), gridspec_kw={"width_ratios": [1, 1.25]}
)

# Bar chart
y_pos = np.arange(len(models))
bar_color = "#1f77b4"
ax1.barh(y_pos, publication_count, color=bar_color)
ax1.set_yticks(y_pos)
ax1.set_yticklabels(models, fontsize=10)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_title(ax1title, fontsize=14)
ax1.set_xlim(ax1xlim)
for i, v in enumerate(publication_count):
    ax1.text(v + 5, i, str(v), color="black", va="center", fontsize=10)

# Heatmap
cmap = "Blues"
im = ax2.imshow(citations, cmap=cmap, aspect="auto")

# We want to show all ticks...
ax2.set_xticks(np.arange(len(models)))
ax2.set_yticks(np.arange(len(models)))
# ... and label them with the respective list entries
ax2.set_xticklabels(models, fontsize=10)
ax2.set_yticklabels(models, fontsize=10)

# Rotate the tick labels and set their alignment.
plt.setp(ax2.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(models)):
    for j in range(len(models)):
        text = ax2.text(
            j, i, "{:.0f}".format(citations[i, j]), ha="center", va="center", color="black", fontsize=10
        )

ax2.set_title(ax2title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_58.pdf", bbox_inches="tight")
