
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots (GDP Growth % and Inflation %)
categories = ["Country A", "Country B"]
gdp_growth = [3.5, 4.2]
inflation_rate = [2.1, 3.8]
gdp_growth_bottom = [0.5, 0.7]
inflation_rate_bottom = [0.3, 0.4]

# Data for line plot (Stock Prices)
years = np.arange(2000, 2021, 1)
country_a_stock = np.random.normal(loc=100, scale=10, size=len(years)).cumsum()
country_b_stock = np.random.normal(loc=120, scale=15, size=len(years)).cumsum()
titles = ["(A) GDP Growth Rate", "(B) Inflation Rate", "(C) Stock Price Trends"]
ax1ylabel = "Percentage (%)"
ax3labels = [
    "Country A Stock Price",
    "Country B Stock Price"
]
ax3xlabel = "Year"
ax3xticks = [2000, 2005, 2010, 2015, 2020]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# GDP Growth Rate Bar Plot
ax1 = plt.subplot(gs[0])
ax1.bar(categories, gdp_growth, color=["#6a994e", "#f4a261"])
ax1.bar(categories, gdp_growth_bottom, color=["#95d5b2", "#f9c74f"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 5)
for i, v in enumerate(gdp_growth):
    ax1.text(i, v - 0.3, str(v), color="black", ha="center")
for i, v in enumerate(gdp_growth_bottom):
    ax1.text(i, v - 0.3, str(v), color="black", ha="center")

# Inflation Rate Bar Plot
ax2 = plt.subplot(gs[1])
ax2.bar(categories, inflation_rate, color=["#e76f51", "#264653"])
ax2.bar(categories, inflation_rate_bottom, color=["#f4a261", "#2a9d8f"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 5)
for i, v in enumerate(inflation_rate):
    ax2.text(i, v - 0.3, str(v), color="black", ha="center")
for i, v in enumerate(inflation_rate_bottom):
    ax2.text(i, v - 0.3, str(v), color="black", ha="center")

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for stock price trends
ax3 = plt.subplot(gs[2])
ax3.plot(
    years,
    country_a_stock,
    "g-o",
    label=ax3labels[0],
    color="#6a994e",
    markersize=4,
)
ax3.plot(
    years,
    country_b_stock,
    "b-s",
    label=ax3labels[1],
    color="#264653",
    markersize=4,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper left", bbox_to_anchor=(1, 1), fontsize=8, frameon=False)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_59.pdf", bbox_inches="tight")
