
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots
categories = ["Technology", "Healthcare"]
companyA_perf = [0.651, 0.638]
companyB_perf = [0.774, 0.792]
companyA_bottom = [0.143, 0.295]
companyB_bottom = [0.494, 0.577]

# Data for line plot
days = np.arange(0, 181, 15)
companyA_stock = [
    0.48, 0.65, 0.72, 0.63, 0.68, 0.75, 0.78, 0.69, 0.65, 0.70, 0.64, 0.73, 0.72
]
companyB_stock = [
    0.52, 0.59, 0.66, 0.58, 0.63, 0.70, 0.73, 0.64, 0.60, 0.65, 0.59, 0.68, 0.67
]
tech_sector = [
    0.60, 0.68, 0.75, 0.70, 0.75, 0.80, 0.82, 0.75, 0.70, 0.75, 0.68, 0.78, 0.77
]
healthcare_sector = [
    0.55, 0.63, 0.70, 0.65, 0.68, 0.75, 0.77, 0.70, 0.65, 0.70, 0.63, 0.73, 0.72
]
titles = ["(A) Company A Performance", "(B) Company B Performance", "(C) Stock Performance Over Time"]
ax1ylabel = "Performance (%)"
ax3labels = [
    "Company A Stock",
    "Company B Stock",
    "Tech Sector",
    "Healthcare Sector",
]
ax3xlabel = "Days"
ax3xticks = [0, 90, 180]
ax3vlines = [0, 90, 180]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot for Company A
ax1 = plt.subplot(gs[0])
ax1.bar(categories, companyA_perf, color=["#82caff", "#aaffc3"])
ax1.bar(categories, companyA_bottom, color=["#3399ff", "#00ff99"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 1)
for i, v in enumerate(companyA_perf):
    ax1.text(i, v - 0.045, f"{v:.3f}", color="black", ha="center", fontsize=8)
for i, v in enumerate(companyA_bottom):
    ax1.text(i, v - 0.045, f"{v:.3f}", color="black", ha="center", fontsize=8)

# Bar plot for Company B
ax2 = plt.subplot(gs[1])
ax2.bar(categories, companyB_perf, color=["#cceeff", "#aaffc3"])
ax2.bar(categories, companyB_bottom, color=["#66ccff", "#00ff99"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 1)
for i, v in enumerate(companyB_perf):
    ax2.text(i, v - 0.045, f"{v:.3f}", color="black", ha="center", fontsize=8)
for i, v in enumerate(companyB_bottom):
    ax2.text(i, v - 0.045, f"{v:.3f}", color="black", ha="center", fontsize=8)

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for stock performance over time - with double the width
ax3 = plt.subplot(gs[2])
ax3.plot(
    days,
    companyA_stock,
    "r-x",
    label=ax3labels[0],
    color="#ff6347",
    markersize=5,
)
ax3.plot(
    days,
    companyB_stock,
    "b-o",
    label=ax3labels[1],
    color="#4682b4",
    markersize=5,
)
ax3.plot(
    days,
    tech_sector,
    "g-^",
    label=ax3labels[2],
    color="#3cb371",
    markersize=5,
)
ax3.plot(
    days,
    healthcare_sector,
    "c-s",
    label=ax3labels[3],
    color="#20b2aa",
    markersize=5,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper right", bbox_to_anchor=(0.95, 1.0), fontsize=8, frameon=False)
ax3.vlines(ax3vlines, 0, 1, colors="k", linestyles="dashed", linewidth=0.75)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_60.pdf", bbox_inches="tight")
