
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(10, 4))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots
categories = ["Treatment A", "Treatment B"]
treatment_a_effectiveness = [0.75, 0.85]
treatment_b_effectiveness = [0.65, 0.78]
treatment_a_side_effects = [0.20, 0.10]
treatment_b_side_effects = [0.30, 0.18]

# Data for line plot
months = np.arange(0, 13, 1)
treatment_a_effect_progress = [0.5, 0.55, 0.57, 0.6, 0.62, 0.65, 0.68, 0.70, 0.72, 0.74, 0.75, 0.77, 0.78]
treatment_b_effect_progress = [0.4, 0.45, 0.48, 0.5, 0.52, 0.54, 0.56, 0.58, 0.6, 0.62, 0.64, 0.66, 0.68]
treatment_a_side_effect_progress = [0.3, 0.28, 0.25, 0.22, 0.2, 0.18, 0.16, 0.14, 0.12, 0.1, 0.09, 0.08, 0.07]
treatment_b_side_effect_progress = [0.4, 0.38, 0.35, 0.32, 0.3, 0.28, 0.26, 0.24, 0.22, 0.2, 0.18, 0.16, 0.15]

titles = ["(A) Treatment Effectiveness", "(B) Side Effects", "(C) Progress Over Time"]
ax1ylabel = "Effectiveness"
ax3labels = [
    "Treatment A Effectiveness",
    "Treatment B Effectiveness",
    "Treatment A Side Effects",
    "Treatment B Side Effects",
]
ax3xlabel = "Months"
ax3xticks = [0, 6, 12]
ax3vlines = [0, 6, 12]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot for Treatment Effectiveness
ax1 = plt.subplot(gs[0])
ax1.bar(categories, treatment_a_effectiveness, color=["#70ad47", "#4472c4"])
ax1.bar(categories, treatment_a_side_effects, color=["#a9d08e", "#a9c4de"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 1)
for i, v in enumerate(treatment_a_effectiveness):
    ax1.text(i, v - 0.045, str(v), color="black", ha="center")
for i, v in enumerate(treatment_a_side_effects):
    ax1.text(i, v - 0.045, str(v), color="black", ha="center")

# Bar plot for Treatment Side Effects
ax2 = plt.subplot(gs[1])
ax2.bar(categories, treatment_b_effectiveness, color=["#5b9bd5", "#ffbf00"])
ax2.bar(categories, treatment_b_side_effects, color=["#9cc3e5", "#ffd966"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 1)
for i, v in enumerate(treatment_b_effectiveness):
    ax2.text(i, v - 0.045, str(v), color="black", ha="center")
for i, v in enumerate(treatment_b_side_effects):
    ax2.text(i, v - 0.045, str(v), color="black", ha="center")

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for Progress Over Time - with double the width
ax3 = plt.subplot(gs[2])
ax3.plot(
    months,
    treatment_a_effect_progress,
    "g-x",
    label=ax3labels[0],
    color="#70ad47",
    markersize=4,
)
ax3.plot(
    months,
    treatment_b_effect_progress,
    "b-o",
    label=ax3labels[1],
    color="#4472c4",
    markersize=4,
)
ax3.plot(
    months,
    treatment_a_side_effect_progress,
    "g-x",
    label=ax3labels[2],
    color="#a9d08e",
    markersize=4,
)
ax3.plot(
    months,
    treatment_b_side_effect_progress,
    "b-o",
    label=ax3labels[3],
    color="#a9c4de",
    markersize=4,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper right", bbox_to_anchor=(0.95, 1.0), fontsize=6, frameon=False)
ax3.vlines(ax3vlines, 0, 1, colors="k", linestyles="dashed", linewidth=0.5)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_61.pdf", bbox_inches="tight")
