
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the line plot
practice_hours = np.array([0, 100, 200, 300, 400, 500])
mastery_level = np.array([1, 2.5, 3, 3.8, 4.2, 5])
mastery_level_error = np.array([0.1, 0.2, 0.15, 0.2, 0.3, 0.25])

# Sample data for the box plot
art_class_ratings = [np.random.normal(80, 10, 100) for _ in range(5)]
class_positions = [0, 100, 200, 300, 400]
# Add scatter data points
ratings_scatter_data = np.random.normal(85, 5, len(class_positions))

# Labels and Titles
titles = ["(a) Mastery Level Over Practice Hours", "(b) Art Class Ratings"]
xlabels = ["Practice Hours", "Art Class"]
ylabels = ["Mastery Level", "Rating"]
xtickslabels = [
    ["0", "100", "200", "300", "400", "500"],
    ["Class 1", "Class 2", "Class 3", "Class 4", "Class 5"],
]
yticks = [np.arange(1, 6, 1), np.arange(60, 101, 10)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, axs = plt.subplots(2, 1, figsize=(6, 8))

# Line plot
axs[0].errorbar(
    practice_hours,
    mastery_level,
    yerr=mastery_level_error,
    fmt="o-",
    ecolor="lightblue",
    markersize=8,
    linewidth=2,
    color="blue",
    linestyle='--',
    marker='s'
)
axs[0].fill_between(practice_hours, mastery_level - mastery_level_error, mastery_level + mastery_level_error, color="lightblue", alpha=0.5)
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].grid(True)
axs[0].set_xticks(practice_hours)
axs[0].set_xticklabels(xtickslabels[0])
axs[0].set_yticks(yticks[0])

# Box plot
axs[1].boxplot(
    art_class_ratings,
    positions=class_positions,
    widths=50,
    showfliers=False,
    boxprops=dict(color="darkgreen", linewidth=2),
    medianprops=dict(color="green", linewidth=2),
    whiskerprops=dict(color="darkgreen", linewidth=2),
    capprops=dict(color="darkgreen", linewidth=2),
)
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].yaxis.grid(True)
axs[1].set_xticks(class_positions)
axs[1].set_xticklabels(xtickslabels[1])
axs[1].set_yticks(yticks[1])

# Scatter plot overlay
axs[1].scatter(class_positions, ratings_scatter_data, marker="^", color="darkgreen", s=100, zorder=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("multidiff_65.pdf", bbox_inches="tight")
