
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for bar plot
categories = ["Coal", "Solar", "Wind"]
values = [0.45, 0.25, 0.3]

# Data for heatmap
data = np.array(
    [[0.75, 0.6, 0.8, 0.55], [0.9, 0.4, 0.1, 0.7], [0.8, 0.65, 0.75, 0.6]]
)
rows = ["Coal", "Solar", "Wind"]
columns = ["Efficiency", "Cost", "Emissions", "Capacity"]
ylabel = "Usage Percentage"
ylim = [0, 0.5]
suptitle = "Energy Performance Metrics"
bar_title = "Energy Source Usage"
heatmap_title = "Energy Comparison by Metric"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the bar plot on the left
plt.figure(figsize=(12, 6))

plt.subplot(1, 2, 1)
bars = plt.bar(categories, values, color=["#3E9651", "#FFDD44", "#3070B3"])
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.title(bar_title)

# Create the heatmap on the right
plt.subplot(1, 2, 2)
heatmap = plt.imshow(
    data, cmap="viridis", interpolation="nearest", vmin=0.0, vmax=1.0
)
plt.xticks(np.arange(len(columns)), columns, rotation=45, ha="right")
plt.yticks(np.arange(len(rows)), rows)
plt.colorbar(heatmap)
plt.title(heatmap_title)

# Annotate the heatmap with text
for i in range(len(rows)):
    for j in range(len(columns)):
        plt.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.suptitle(suptitle)
plt.tight_layout()
plt.subplots_adjust(top=0.85)  # Adjust the top to make room for the suptitle

plt.savefig("multidiff_68.pdf", bbox_inches="tight")
