
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for bar chart
categories = ["Abstract", "Surreal", "Expressionism", "Cubism"]
successful_art_pieces = [45, 70, 55, 40]

# Data for boxplot
artistic_value_data = [np.random.normal(0.55, 0.10, 100) for _ in categories]

success_threshold_upper = 0.70
success_threshold_lower = 0.40
ylabels = ["# Successful\nArt Pieces", "Artistic Value"]
ax2hlineslabels = ["Upper Artistic Value Threshold", "Lower Artistic Value Threshold"]
ax2ylim = [0.0, 1.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots; ax1 and ax2 share the same x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8), sharex=True)

# Bar chart
ax1.bar(
    categories,
    successful_art_pieces,
    hatch="\\",
    color="#6495ED",
    edgecolor="black",
    width=0.6,
)
ax1.set_ylabel(ylabels[0])

# Boxplot chart
ax2.boxplot(artistic_value_data, positions=range(len(categories)), widths=0.6, patch_artist=True,
            boxprops=dict(facecolor="#87CEFA", color="black"),
            medianprops=dict(color="black", linewidth=1.5))
ax2.hlines(
    success_threshold_upper,
    xmin=-0.5,
    xmax=len(categories) - 0.5,
    colors="green",
    linestyles="dashed",
    label=ax2hlineslabels[0],
)
ax2.hlines(
    success_threshold_lower,
    xmin=-0.5,
    xmax=len(categories) - 0.5,
    colors="red",
    linestyles="dashed",
    label=ax2hlineslabels[1],
)
ax2.fill_between(
    [-0.5, len(categories) - 0.5],
    success_threshold_lower,
    success_threshold_upper,
    color="grey",
    alpha=0.15,
)
ax2.set_ylabel(ylabels[1])
ax2.yaxis.set_major_formatter(plt.FuncFormatter(lambda x, _: f"{x:.2f}"))
ax2.set_ylim(ax2ylim)
ax2.set_xticklabels(categories)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_73.pdf", bbox_inches="tight")
