
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
tech_sector = np.array([50, 55, 60, 65, 70, 75, 80, 85])
finance_sector = np.array([40, 43, 47, 50, 53, 56, 60, 64])
health_sector = np.array([30, 35, 40, 45, 50, 55, 60, 65])

# Data for Box Plot
data_big_bank = np.random.normal(15, 5, 100)
data_investment_firms = np.random.normal(20, 10, 100)
data_insurance = np.random.normal(10, 7, 100)
data_fintech = np.random.normal(25, 15, 100)
data = [data_big_bank, data_investment_firms, data_insurance, data_fintech]

# Labels and Titles
sector_labels = ["Technology", "Finance", "Healthcare"]
titles = [
    "Sector Performance Over Time",
    "Profit Margins across Financial Sectors",
]
xlabels = ["Year"]
boxplot_xtickslabels = ["Big Banks", "Investment Firms", "Insurance", "Fintech"]
ylabels = ["Performance Index", "Profit Margin (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# ----- Area Chart for Sector Performance -----
# Calculate cumulative values for stacked area chart
cumulative_tech = tech_sector
cumulative_finance = cumulative_tech + finance_sector
cumulative_health = cumulative_finance + health_sector

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_tech, label=sector_labels[0], color="#4caf50", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_tech,
    cumulative_finance,
    label=sector_labels[1],
    color="#2196f3",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_finance,
    cumulative_health,
    label=sector_labels[2],
    color="#ff9800",
    alpha=0.7,
)

ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")
ax1.grid(True, linestyle='--', alpha=0.6)

# ----- Box Plot for Profit Margins in Financial Sectors -----
# Creating Box Plot
bp = ax2.boxplot(data, patch_artist=True, notch=False, showfliers=True)

# Customizing boxplot colors
colors = ["#4caf50", "#2196f3", "#ff9800", "#f44336"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

# Setting labels and titles
ax2.set_xticklabels(boxplot_xtickslabels)
ax2.set_ylabel(ylabels[1])
ax2.set_title(titles[1])
ax2.yaxis.grid(True, linestyle='--', alpha=0.6)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_77.pdf", bbox_inches="tight")
