
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for Area Chart
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
urbanization = np.array([40, 42, 45, 48, 50, 55, 58, 60])
deforestation = np.array([30, 28, 26, 25, 23, 20, 18, 15])
renewable_energy = np.array([5, 7, 10, 15, 20, 25, 30, 35])

# Data for Box Plot
data_urban = np.random.normal(60, 10, 100)
data_rural = np.random.normal(40, 15, 100)
data_coastal = np.random.normal(50, 12, 100)
data_mountainous = np.random.normal(30, 18, 100)
data = [data_urban, data_rural, data_coastal, data_mountainous]

# Labels and Titles
area_labels = ["Urbanization", "Deforestation", "Renewable Energy"]
chart_titles = [
    "Geographical Trends Over Years",
    "Environmental Indicators Across Regions",
]
x_axis_label = ["Year"]
region_labels = ["Urban", "Rural", "Coastal", "Mountainous"]
y_axis_labels = ["Percentage (%)", "Air Quality Index"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# ----- Area Chart for Geographical Trends -----
# Calculate cumulative values for stacked area chart
cumulative_urbanization = urbanization
cumulative_deforestation = cumulative_urbanization + deforestation
cumulative_renewable_energy = cumulative_deforestation + renewable_energy

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_urbanization, label=area_labels[0], color="#4CAF50", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_urbanization,
    cumulative_deforestation,
    label=area_labels[1],
    color="#8B4513",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_deforestation,
    cumulative_renewable_energy,
    label=area_labels[2],
    color="#1E90FF",
    alpha=0.7,
)

ax1.set_title(chart_titles[0])
ax1.set_xlabel(x_axis_label[0])
ax1.set_ylabel(y_axis_labels[0])
ax1.legend(loc="upper left")
ax1.grid(True)

# ----- Box Plot for Environmental Indicators -----
# Creating Box Plot
bp = ax2.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing boxplot colors
colors = ["#4CAF50", "#8B4513", "#1E90FF", "#FFD700"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black")

# Setting labels and titles
ax2.set_xticklabels(region_labels)
ax2.set_ylabel(y_axis_labels[1])
ax2.set_title(chart_titles[1])
ax2.yaxis.grid(True)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_78.pdf", bbox_inches="tight")
