
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart
years = ["2000", "2005", "2010", "2015", "2020", "2025"]
rationalism = np.array([10, 12, 14, 16, 18, 20])
empiricism = np.array([8, 11, 13, 14, 15, 18])
existentialism = np.array([5, 7, 9, 12, 15, 17])

# Data for Box Plot
data_western = np.random.normal(50, 10, 100)
data_eastern = np.random.normal(40, 12, 100)
data_islamic = np.random.normal(30, 8, 100)
data_african = np.random.normal(20, 15, 100)
box_data = [data_western, data_eastern, data_islamic, data_african]

# Text and Label Parameters
area_labels = ["Rationalism", "Empiricism", "Existentialism"]
plot_titles = [
    "Growth of Philosophical Schools",
    "Spread of Philosophical Thoughts by Region",
]
xlabels = ["Year"]
box_xtick_labels = ["Western", "Eastern", "Islamic", "African"]
ylabels = ["Growth (%)", "Philosophical Thought Spread (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# ----- Area Chart for Philosophical Growth -----
# Calculate cumulative values for stacked area chart
cumulative_rationalism = rationalism
cumulative_empiricism = cumulative_rationalism + empiricism
cumulative_existentialism = cumulative_empiricism + existentialism

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_rationalism, label=area_labels[0], color="#8c564b", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_rationalism,
    cumulative_empiricism,
    label=area_labels[1],
    color="#e377c2",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_empiricism,
    cumulative_existentialism,
    label=area_labels[2],
    color="#7f7f7f",
    alpha=0.7,
)

ax1.set_title(plot_titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")
ax1.grid(True)

# ----- Box Plot for Philosophical Thought Spread -----
# Creating Box Plot
bp = ax2.boxplot(box_data, patch_artist=True, notch=False, showfliers=False)

# Customizing boxplot colors
box_colors = ["#bcbd22", "#17becf", "#9edae5", "#ff9896"]
for patch, color in zip(bp["boxes"], box_colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black")

# Setting labels and titles
ax2.set_xticklabels(box_xtick_labels)
ax2.set_ylabel(ylabels[1])
ax2.set_title(plot_titles[1])
ax2.yaxis.grid(True)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_79.pdf", bbox_inches="tight")
