
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# ErrorBar Plot Data for "Average Weekly Attendance"
# Countries
countries = ["USA", "UK", "Germany", "France", "Italy", "Spain"]
# Hypothetical average weekly attendance rates
attendance_rates = [30, 22, 18, 25, 28, 20]
# Standard errors for the above attendance rates
attendance_errors = [2, 1.8, 1.5, 2.1, 2.2, 1.7]

# ErrorPoint Plot Data for "Percentage of People Following Each Religion Type"
# Types of religions
religion_types = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism"]
# Randomly generated means and standard deviations for percentages
religion_percentages = np.random.uniform(20, 80, len(religion_types))
std_devs = np.random.uniform(2, 5, len(religion_types))
mean_percentage = np.mean(religion_percentages)

# Titles and Labels
titles = ["Average Weekly Attendance at Religious Services by Country", "Percentage of People Following Each Religion Type"]
ylabels = ["Attendance Rate (%)", "Percentage (%)"]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes for the subplots
fig, axes = plt.subplots(2, 1, figsize=(8, 10))

# ErrorBar Plot
axes[0].bar(
    countries, attendance_rates, yerr=attendance_errors, color="#2a9d8f", capsize=5, ecolor="grey"
)
axes[0].set_title(titles[0])
axes[0].set_ylabel(ylabels[0])
axes[0].grid(True)

# ErrorPoint Plot
axes[1].errorbar(
    religion_types,
    religion_percentages,
    yerr=std_devs,
    fmt="o",
    color="#264653",
    ecolor="#264653",
    capsize=5,
    ms=8,
)
axes[1].axhline(y=mean_percentage, color="grey", linestyle="--")
axes[1].set_title(titles[1])
axes[1].set_ylabel(ylabels[1])
axes[1].set_ylim(ylim)
axes[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to avoid overlap and save the figure
plt.tight_layout()
plt.savefig("multidiff_82.pdf", bbox_inches="tight")
