
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Redefined data for Area Chart - Popularity of political parties over election years
periods = ["2016", "2018", "2020", "2022"]
party_a = np.array([30, 40, 35, 50])
party_b = np.array([40, 35, 45, 30])
party_c = np.array([25, 20, 15, 15])

# Adjust the cumulative calculation for clarity in visualization
cumulative_party_a = party_a
cumulative_party_b = cumulative_party_a + party_b
cumulative_party_c = cumulative_party_b + party_c

# New data for Bar Chart - Popularity of political ideologies
ideologies = ["Liberal", "Conservative", "Centrist", "Libertarian", "Green", "Socialist"]
popularity = [250, 200, 175, 150, 125, 100]

# Redefined data for Histogram - Distribution of campaign donations
urban_donations = np.random.normal(50000, 10000, 1000)
rural_donations = np.random.normal(30000, 12000, 1000)
bins = np.linspace(0, 100000, 30)  # Uniform bin size for both histograms
ax1labels = ["Party A", "Party B", "Party C"]
titles = [
    "Political Party Popularity Over Time",
    "Popularity of Political Ideologies",
    "Campaign Donations Distribution by Region",
]
xlabels = ["Year", "Ideology", "Donation Amount ($)"]
ylabels = ["Popularity (%)", "Number of Respondents", "Frequency"]
ax3label=["Urban Donations", "Rural Donations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    periods,
    cumulative_party_a,
    cumulative_party_b,
    cumulative_party_c,
    labels=ax1labels,
    colors=["#d73027", "#fc8d59", "#fee08b"],
    alpha=0.85,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart with new data
ax2.bar(ideologies, popularity, color="#91bfdb")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(ideologies, rotation=40, ha='right')

# Plotting two overlapping Histograms
ax3.hist(urban_donations, bins=bins, color="#4575b4", alpha=0.6, label=ax3label[0])
ax3.hist(rural_donations, bins=bins, color="#d73027", alpha=0.6, label=ax3label[1])
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_86.pdf", bbox_inches="tight")

