
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting a random seed for reproducibility
np.random.seed(0)

# Redefined data for Area Chart - Energy Consumption Growth Over Time
periods = ["2019", "2020", "2021", "2022"]
renewable_energy = np.array([20, 30, 40, 50])
fossil_fuels = np.array([60, 55, 50, 45])
nuclear_energy = np.array([20, 15, 10, 5])

# Adjust the cumulative calculation for clarity in visualization
cumulative_renewable = renewable_energy
cumulative_fossil = cumulative_renewable + fossil_fuels
cumulative_nuclear = cumulative_fossil + nuclear_energy

# New data for Bar Chart - Popularity of Energy Sources
energy_sources = ["Renewables", "Fossil Fuels", "Nuclear", "Hydro", "Geothermal", "Wind"]
popularity = [220, 180, 160, 140, 130, 120]

# Redefined data for Histogram - Energy cost distribution in urban vs rural areas
urban_costs = np.random.normal(120, 20, 1000)
rural_costs = np.random.normal(90, 25, 1000)
bins = np.linspace(30, 210, 30)  # Uniform bin size for both histograms

# Labels and titles
ax1labels = ["Renewable Energy", "Fossil Fuels", "Nuclear Energy"]
titles = [
    "Energy Consumption Growth Over Time",
    "Popularity of Energy Sources",
    "Energy Cost Distribution by Region",
]
xlabels = ["Year", "Energy Source", "Energy Cost ($)"]
ylabels = ["Total Consumption (%)", "Number of Responses", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    periods,
    cumulative_renewable,
    cumulative_fossil,
    cumulative_nuclear,
    labels=ax1labels,
    colors=["#66c2a5", "#fc8d62", "#8da0cb"],
    alpha=0.8,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper right")

# Plotting the Bar Chart with different data
ax2.bar(energy_sources, popularity, color="#8e99f3")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(energy_sources, rotation=45)

# Plotting two overlapping Histograms
ax3.hist(urban_costs, bins=bins, color="#66c2a5", alpha=0.7, label="Urban Costs")
ax3.hist(rural_costs, bins=bins, color="#fc8d62", alpha=0.7, label="Rural Costs")
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_87.pdf", bbox_inches="tight")
