
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Redefined data for Area Chart - Number of books published in different genres over decades
decades = ["1980s", "1990s", "2000s", "2010s"]
fiction = np.array([50, 70, 90, 110])
nonfiction = np.array([30, 50, 80, 100])
poetry = np.array([10, 15, 20, 25])

# Adjust the cumulative calculation for clarity in visualization
cumulative_fiction = fiction
cumulative_nonfiction = cumulative_fiction + nonfiction
cumulative_poetry = cumulative_nonfiction + poetry

# New data for Bar Chart - Genre popularity based on sales
genres = ["Fiction", "Non-Fiction", "Poetry", "Mystery", "Romance", "Sci-Fi"]
sales = [500, 400, 150, 300, 350, 250]

# Redefined data for Histogram - Book length distribution in pages for Fiction and Non-Fiction
fiction_lengths = np.random.normal(300, 50, 1000)
nonfiction_lengths = np.random.normal(350, 60, 1000)
bins = np.linspace(100, 600, 30)  # Uniform bin size for both histograms
ax1labels = ["Fiction", "Non-Fiction", "Poetry"]
titles = [
    "Number of Books Published Over Decades",
    "Popularity of Book Genres",
    "Book Length Distribution by Genre",
]
xlabels = ["Decade", "Genre", "Page Count"]
ylabels = ["Total Books Published", "Sales (in thousands)", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    decades,
    cumulative_fiction,
    cumulative_nonfiction,
    cumulative_poetry,
    labels=ax1labels,
    colors=["#ff9999", "#66b3ff", "#99ff99"],
    alpha=0.8,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart with different data
ax2.bar(genres, sales, color="#c2a5cf")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(genres, rotation=45)

# Plotting two overlapping Histograms
ax3.hist(fiction_lengths, bins=bins, color="#8dd3c7", alpha=0.7, label="Fiction")
ax3.hist(nonfiction_lengths, bins=bins, color="#fb8072", alpha=0.7, label="Non-Fiction")
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_88.pdf", bbox_inches="tight")
